<?php $__env->startSection('title', __('app.dashboard')); ?>

		<?php $__env->startSection('content'); ?>
		<!--start page wrapper -->
		<div class="page-wrapper">
			<div class="page-content">

                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('dashboard.can.view.widget.cards')): ?>
				<div class="row row-cols-1 row-cols-md-2 row-cols-xl-4">
                   <div class="col">
					 <div class="card radius-10 border-start border-0 border-4 border-info">
						<div class="card-body">
							<div class="d-flex align-items-center">
								<div>
									<p class="mb-0 text-secondary"><?php echo e(__('sale.order.pending')); ?></p>
									<h4 class="my-1 text-info"><?php echo e($pendingSaleOrders); ?></h4>

								</div>
								<div class="widgets-icons-2 rounded-circle bg-gradient-blues text-white ms-auto"><i class='bx bxs-cart'></i>
								</div>
							</div>
						</div>
					 </div>
				   </div>
				   <div class="col">
					<div class="card radius-10 border-start border-0 border-4 border-success">
					   <div class="card-body">
						   <div class="d-flex align-items-center">
							   <div>
								   <p class="mb-0 text-secondary"><?php echo e(__('sale.order.completed')); ?></p>
									<h4 class="my-1 text-success"><?php echo e($totalCompletedSaleOrders); ?></h4>

							   </div>
							   <div class="widgets-icons-2 rounded-circle bg-gradient-ohhappiness text-white ms-auto"><i class='bx bxs-check-circle' ></i>
							   </div>
						   </div>
					   </div>
					</div>
				  </div>
				   <div class="col">
					<div class="card radius-10 border-start border-0 border-4 border-danger">
					   <div class="card-body">
						   <div class="d-flex align-items-center">
							   <div>
								   <p class="mb-0 text-secondary"><?php echo e(__('payment.payment_receivables')); ?></p>
									<h4 class="my-1 text-danger"><?php echo e($totalPaymentReceivables); ?></h4>

							   </div>
							   <div class="widgets-icons-2 rounded-circle bg-gradient-burning text-white ms-auto"><i class='bx bxs-down-arrow-circle'></i>
							   </div>
						   </div>
					   </div>
					</div>
				  </div>

				  <div class="col">
					<div class="card radius-10 border-start border-0 border-4 border-warning">
					   <div class="card-body">
						   <div class="d-flex align-items-center">
							   <div>
								   <p class="mb-0 text-secondary"><?php echo e(__('payment.payment_paybles')); ?></p>
									<h4 class="my-1 text-warning"><?php echo e($totalPaymentPaybles); ?></h4>

							   </div>
							   <div class="widgets-icons-2 rounded-circle bg-gradient-orange text-white ms-auto"><i class='bx bxs-up-arrow-circle'></i>
							   </div>
						   </div>
					   </div>
					</div>
				  </div>
				</div><!--end row-->

				<div class="row row-cols-1 row-cols-md-2 row-cols-xl-4">
                   <div class="col">
					 <div class="card radius-10 border-start border-0 border-4 border-info">
						<div class="card-body">
							<div class="d-flex align-items-center">
								<div>
									<p class="mb-0 text-secondary"><?php echo e(__('purchase.order.pending')); ?></p>
									<h4 class="my-1 text-info"><?php echo e($pendingPurchaseOrders); ?></h4>

								</div>
								<div class="widgets-icons-2 rounded-circle bg-gradient-blues text-white ms-auto"><i class='bx bxs-purchase-tag'></i>
								</div>
							</div>
						</div>
					 </div>
				   </div>
				   <div class="col">
					<div class="card radius-10 border-start border-0 border-4 border-success">
					   <div class="card-body">
						   <div class="d-flex align-items-center">
							   <div>
								   <p class="mb-0 text-secondary"><?php echo e(__('purchase.order.completed')); ?></p>
									<h4 class="my-1 text-success"><?php echo e($totalCompletedPurchaseOrders); ?></h4>

							   </div>
							   <div class="widgets-icons-2 rounded-circle bg-gradient-ohhappiness text-white ms-auto"><i class='bx bx-check-double' ></i>
							   </div>
						   </div>
					   </div>
					</div>
				  </div>
				   <div class="col">
					<div class="card radius-10 border-start border-0 border-4 border-danger">
					   <div class="card-body">
						   <div class="d-flex align-items-center">
							   <div>
								   <p class="mb-0 text-secondary"><?php echo e(__('expense.total_expenses')); ?></p>
									<h4 class="my-1 text-danger"><?php echo e($totalExpense); ?></h4>
							   </div>
							   <div class="widgets-icons-2 rounded-circle bg-gradient-burning text-white ms-auto"><i class='bx bxs-minus-circle'></i>
							   </div>
						   </div>
					   </div>
					</div>
				  </div>

				  <div class="col">
					<div class="card radius-10 border-start border-0 border-4 border-warning">
					   <div class="card-body">
						   <div class="d-flex align-items-center">
							   <div>
								   <p class="mb-0 text-secondary"><?php echo e(__('customer.total')); ?></p>
									<h4 class="my-1 text-warning"><?php echo e($totalCustomers); ?></h4>

							   </div>
							   <div class="widgets-icons-2 rounded-circle bg-gradient-orange text-white ms-auto"><i class='bx bxs-group'></i>
							   </div>
						   </div>
					   </div>
					</div>
				  </div>
				</div><!--end row-->
                <?php endif; ?>
				<div class="row">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('dashboard.can.view.sale.vs.purchase.bar.chart')): ?>
                   <div class="col-12 col-lg-8 d-flex">
                      <div class="card radius-10 w-100">
						<div class="card-header">
							<div class="d-flex align-items-center">
								<div>
									<h6 class="mb-0"><?php echo e(__('sale.sale_vs_purchase')); ?></h6>
								</div>
							</div>
						</div>
						  <div class="card-body">
							<div class="d-flex align-items-center ms-auto font-13 gap-2 mb-3">
								<span class="border px-1 rounded cursor-pointer"><i class="bx bxs-circle me-1" style="color: #ffc107"></i><?php echo e(__('purchase.purchase_bills')); ?></span>
								<span class="border px-1 rounded cursor-pointer"><i class="bx bxs-circle me-1" style="color: #14abef"></i><?php echo e(__('sale.sale_invoices')); ?></span>
							</div>
							<div class="chart-container-1">
								<canvas id="chart1"></canvas>
							</div>
						  </div>
					  </div>
				   </div>
                   <?php endif; ?>
                   <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('dashboard.can.view.trending.items.pie.chart')): ?>
				   <div class="col-12 col-lg-4 d-flex">
                       <div class="card radius-10 w-100">
						<div class="card-header">
							<div class="d-flex align-items-center">
								<div>
									<h6 class="mb-0"><?php echo e(__('item.trending')); ?></h6>
								</div>
							</div>
						</div>
						   <div class="card-body">
							<div class="chart-container-2">
								<canvas id="chart2"></canvas>
							  </div>
						   </div>
						   <ul class="list-group list-group-flush">
								<?php $__currentLoopData = $trendingItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
								  <li class="list-group-item d-flex bg-transparent justify-content-between align-items-center border-top">
								    <?php echo e($item['name']); ?>

								    <span class="badge bg-success rounded-pill"><?php echo e($formatNumber->formatQuantity($item['total_quantity'])); ?></span>
								  </li>
								<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
						</ul>
					   </div>
				   </div>
                   <?php endif; ?>
				</div><!--end row-->

                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('dashboard.can.view.recent.invoices.table')): ?>
				 <div class="card radius-10">
					<div class="card-header">
						<div class="d-flex align-items-center">
							<div>
								<h6 class="mb-0"><?php echo e(__('sale.recent_invoices')); ?></h6>
							</div>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('sale.invoice.view')): ?>
                            <div class="font-13 ms-auto">
                                <a href="<?php echo e(route('sale.invoice.list')); ?>" class="btn btn-sm btn-outline-primary"><?php echo e(__('app.view_all')); ?></a>
                            </div>
                            <?php endif; ?>
						</div>
					</div>
                    <div class="card-body">
                        <div class="table-responsive">
                        <table class="table align-middle mb-0">
                            <thead class="table-light">
                            <tr>
                                <th><?php echo e(__('sale.invoice_date')); ?></th>
                                <th><?php echo e(__('sale.code')); ?></th>
                                <th><?php echo e(__('customer.name')); ?></th>
                                <th><?php echo e(__('app.grand_total')); ?></th>
                                <th><?php echo e(__('app.balance')); ?></th>
                                <th><?php echo e(__('app.status')); ?></th>
                            </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $recentInvoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $recent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                        <tr>
                                            <td><?php echo e($recent->formatted_sale_date); ?></td>
                                            <td><?php echo e($recent->sale_code); ?></td>
                                            <td><?php echo e($recent->party->getFullName()); ?></td>
                                            <td class=""><?php echo e($formatNumber->formatWithPrecision($recent->grand_total)); ?></td>
                                            <td class=""><?php echo e($formatNumber->formatWithPrecision($recent->grand_total - $recent->paid_amount)); ?></td>

                                            <?php
                                                if($recent->grand_total == $recent->paid_amount){
                                                    $class = 'success';
                                                    $message = 'Paid';
                                                }else if($recent->grand_total < $recent->paid_amount){
                                                    $class = 'warning';
                                                    $message = 'Partial';
                                                }else{
                                                    $class = 'danger';
                                                    $message = 'Unpaid';
                                                }
                                            ?>

                                            <td class=""><div class="badge rounded-pill text-<?php echo e($class); ?> bg-light-<?php echo e($class); ?> p-2 text-uppercase px-3"><?php echo e($message); ?></div></td>
                                        </tr>

                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                        </div>
                    </div>
                </div>
                <?php endif; ?>

                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('dashboard.can.view.low.stock.items.table')): ?>
				 <div class="card radius-10">
					<div class="card-header">
						<div class="d-flex align-items-center">
							<div>
								<h6 class="mb-0"><?php echo e(__('item.low_stock_items')); ?></h6>
							</div>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('item.view')): ?>
                            <div class="font-13 ms-auto">
                                <a href="<?php echo e(route('item.list')); ?>" class="btn btn-sm btn-outline-primary"><?php echo e(__('app.view_all')); ?></a>
                            </div>
                            <?php endif; ?>
						</div>
					</div>
                    <div class="card-body">
                        <div class="table-responsive">
                        <table class="table align-middle mb-0">
                            <thead class="table-light">
                                <tr class="text-uppercase">
                                    <th>#</th>
                                    <th><?php echo e(__('item.item_name')); ?></th>
                                    <th><?php echo e(__('item.brand.brand')); ?></th>
                                    <th><?php echo e(__('item.category.category')); ?></th>
                                    <th><?php echo e(__('item.min_stock')); ?></th>
                                    <th><?php echo e(__('item.current_stock')); ?></th>
                                    <th><?php echo e(__('unit.unit')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $i = 1; ?>
                                <?php $__currentLoopData = $lowStockItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($i++); ?></td>
                                            <td><?php echo e($item->name); ?></td>
                                            <td><?php echo e($item->brand->name??''); ?></td>
                                            <td><?php echo e($item->category->name); ?></td>
                                            <td class=""><?php echo e($formatNumber->formatQuantity($item->min_stock)); ?></td>
                                            <td class="text-danger fw-bold"><?php echo e($formatNumber->formatQuantity($item->current_stock)); ?></td>
                                            <td><?php echo e($item->baseUnit->name); ?></td>
                                        </tr>

                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                        </div>
                    </div>
                </div>
                <?php endif; ?>



			</div>
		</div>
		<!--end page wrapper -->
		<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script src="<?php echo e(versionedAsset('custom/js/dashboard.js')); ?>"></script>
<script src="<?php echo e(versionedAsset('custom/js/custom.js')); ?>"></script>
<script>
	/*Bar Chart Data*/
	var chartMonths = <?php echo json_encode($saleVsPurchase, 15, 512) ?>.map(record => record.label);
	var chartSales = <?php echo json_encode($saleVsPurchase, 15, 512) ?>.map(record => record.sales);
	var chartPurchases = <?php echo json_encode($saleVsPurchase, 15, 512) ?>.map(record => record.purchases);

	/*Doughnut Chart Data*/
	var serviceNames = <?php echo json_encode($trendingItems, 15, 512) ?>.map(x => x.name);
	var serviceCounts = <?php echo json_encode($trendingItems, 15, 512) ?>.map(x => x.total_quantity);

</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/eltaqwa/public_html/delta-source-code/resources/views/dashboard.blade.php ENDPATH**/ ?>