<!DOCTYPE html>
<html lang="ar" dir="<?php echo e($appDirection); ?>">
<head>
    <meta charset="UTF-8">
    <title><?php echo e(__('payment.payment_receipt')); ?></title>
    <?php echo $__env->make('print.common.css', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</head>
<body onload="window.print();">
    <div class="invoice-container">
        <span class="invoice-name"><?php echo e(__('payment.payment_receipt')); ?></span>
        <div class="invoice">
            <table class="header">
                <tr>
                    <?php echo $__env->make('print.common.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                    <td class="bill-info">
                        <span class="bill-number"><?php echo e(__('payment.receipt_no')); ?> #: <?php echo e($payment->reference_no); ?></span><br>
                        <span class="cu-fs-16"><?php echo e(__('payment.date')); ?>: <?php echo e($payment->formatted_transaction_date); ?></span><br>
                        <span class="cu-fs-16"><?php echo e(__('app.time')); ?>: <?php echo e($payment->format_created_time); ?></span><br>
                    </td>
                </tr>
            </table>
            <table class="addresses">
                <tr>
                    <td class="address">
                        <span class="fw-bold cu-fs-18"><?php echo e(__('payment.received_from')); ?></span><br>
                        <span><?php echo e($model->party->first_name.' '. $model->party->last_name); ?><br>
                        <?php echo e($model->party->billing_address); ?></span>
                    </td>
                </tr>
            </table>

        <table class="table-bordered custom-table table-compact" id="item-table">
            <thead>
                <tr>
                    <th><?php echo e(__('payment.payment_type')); ?></th>
                    <th><?php echo e(__('payment.amount')); ?></th>
                </tr>
            </thead>
            <tbody>

                <tr>

                    <td class="text-left">
                        <b><?php echo e($payment->paymentType->name); ?></b>
                   </td>
                   <td class="text-end">
                       <?php echo e($formatNumber->formatWithPrecision($payment->amount)); ?>

                   </td>
                </tr>
                <tr>
                    <td>
                        <?php echo e(__('party.due_balance')); ?> <?php echo e($balanceData['status']=='you_pay' ? '(Pay)' : ($balanceData['status']=='you_collect' ? '(Collect)' : '')); ?>

                    </td>
                    <td class="text-end">
                       <?php echo e($formatNumber->formatWithPrecision($balanceData['balance'])); ?>

                   </td>
                </tr>

            </tbody>
        </table>


        <table class="">
            <tr>
                <td class="signature">
                     <?php if(app('company')['show_signature_on_invoice']): ?>
                         <?php
                            if($isPdf){
                                 //No image Path
                                $defaultSignature = 'app/public/images/noimages/no-image-found.jpg';

                                //Company logo path
                                $signaturePath = 'app/public/images/signature/';

                                $signature = storage_path(
                                    !empty(app('company')['signature']) &&
                                    file_exists(storage_path($signaturePath . app('company')['signature']))
                                        ? $signaturePath . app('company')['signature']
                                        : $defaultSignature
                                );


                            }else{
                                //Routing or direct view
                                $signature = url('/company/signature/getimage/'.app('company')['signature']);
                            }
                        ?>

                        <img src="<?php echo e($signature); ?>" alt="Logo" class="company-logo">
                        <?php endif; ?>
                        <p><?php echo e(app('company')['name']); ?></p>
                        <p><?php echo e(__('app.authorized_signatory')); ?></p>
                </td>
            </tr>
        </table>


    </div>
    </div>
</body>
</html>
<?php /**PATH /home/eltaqwa/public_html/delta-source-code/resources/views/print/return-payment-receipt.blade.php ENDPATH**/ ?>