<!DOCTYPE html>
<html lang="ar" dir="<?php echo e($appDirection); ?>">
<head>
    <meta charset="UTF-8">
    <title><?php echo e($invoiceData['name']); ?></title>
    <?php echo $__env->make('print.common.css', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</head>
<body onload="window.print();">
    <div class="invoice-container">
        <span class="invoice-name"><?php echo e($invoiceData['name']); ?></span>
        <div class="invoice">
            <table class="header">
                <tr>
                    <?php echo $__env->make('print.common.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                    <td class="bill-info">
                        <span class="bill-number"><?php echo e(__('app.bill')); ?> #: <?php echo e($order->order_code); ?></span><br>
                        <span class="cu-fs-16"><?php echo e(__('order.date')); ?>: <?php echo e($order->formatted_order_date); ?></span><br>
                        <span class="cu-fs-16"><?php echo e(__('app.time')); ?>: <?php echo e($order->format_created_time); ?></span><br>
                        <?php if($order->due_date): ?>
                        <span class="cu-fs-16"><?php echo e(__('app.due_date')); ?>: <?php echo e($formatDate->toUserDateFormat($order->due_date)); ?></span>
                        <?php endif; ?>
                    </td>
                </tr>
            </table>



            <table class="addresses">
                <tr>
                    <td class="address">
                        <span class="fw-bold cu-fs-18"><?php echo e(__('app.order_to')); ?></span><br>
                        <span><?php echo e($order->party->first_name.' '. $order->party->last_name); ?><br>
                        <?php echo e($order->party->billing_address); ?></span>
                        
                        <?php echo $__env->make('print.common.party-tax-details', ['model' => $order], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </td>
                    <td class="address">
                        <span class="fw-bold cu-fs-18"><?php echo e(__('app.ship_from')); ?></span><br>
                        <span><?php echo e($order->party->shipping_address); ?></span>
                    </td>
                </tr>
            </table>


         <?php
            $isHasBatchItem = ($order->itemTransaction->where('tracking_type', 'batch')->count() > 0) ? true : false;

            //Return from Controller
            $totalBatchTrackingRowCount = ($isHasBatchItem) ? $batchTrackingRowCount : 0;
        ?>
        <table class="table-bordered custom-table table-compact" id="item-table">
            <thead>
                <tr>
                    <th>#</th>
                    <th><?php echo e(__('item.item')); ?></th>
                    <?php if(app('company')['show_hsn']): ?>
                    <th><?php echo e(__('item.hsn')); ?></th>
                    <?php endif; ?>
                    <?php if($isHasBatchItem): ?>
                        <?php if(app('company')['enable_batch_tracking']): ?>
                        <th><?php echo e(__('item.batch_no')); ?></th>
                        <?php endif; ?>
                        <?php if(app('company')['enable_mfg_date']): ?>
                        <th><?php echo e(__('item.mfg_date')); ?></th>
                        <?php endif; ?>
                        <?php if(app('company')['enable_exp_date']): ?>
                        <th><?php echo e(__('item.exp_date')); ?></th>
                        <?php endif; ?>
                        <?php if(app('company')['enable_model']): ?>
                        <th><?php echo e(__('item.model_no')); ?></th>
                        <?php endif; ?>

                        <?php if(app('company')['enable_color']): ?>
                        <th><?php echo e(__('item.color')); ?></th>
                        <?php endif; ?>
                        <?php if(app('company')['enable_size']): ?>
                        <th><?php echo e(__('item.size')); ?></th>
                        <?php endif; ?>
                    <?php endif; ?>
                    <?php if(app('company')['show_mrp']): ?>
                    <th><?php echo e(__('item.mrp')); ?></th>
                    <?php endif; ?>
                    <th><?php echo e(__('app.qty')); ?></th>
                    <th><?php echo e(__('app.price_per_unit')); ?></th>
                    <?php if(app('company')['show_discount']): ?>
                    <th><?php echo e(__('app.discount')); ?></th>
                    <?php endif; ?>
                    <?php if(app('company')['tax_type'] != 'no-tax'): ?>
                    <th><?php echo e(__('tax.tax')); ?></th>
                    <?php endif; ?>
                    <th><?php echo e(__('app.total')); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php
                    $i=1;
                ?>

                <?php $__currentLoopData = $order->itemTransaction; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td class="no"><?php echo e($i++); ?></td>
                    <td class="text-left">
                        <!-- Service Name -->
                        <b><?php echo e($transaction->item->name); ?></b>
                        <!-- Description -->
                        <small><?php echo e($transaction->description); ?></small>
                        
                        <?php echo $__env->make('print.common.brand-details', ['model' => $transaction], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <small>
                            <?php if($transaction->itemSerialTransaction->count() > 0): ?>
                                <br><?php echo e($transaction->itemSerialTransaction->pluck('itemSerialMaster.serial_code')->implode(',')); ?><br>
                            <?php endif; ?>
                        </small>

                   </td>
                   <?php if(app('company')['show_hsn']): ?>
                   <td>
                       <?php echo e($transaction->item->hsn); ?>

                   </td>
                   <?php endif; ?>
                   <?php if($isHasBatchItem): ?>

                       <?php if(app('company')['enable_batch_tracking']): ?>
                       <td>
                           <?php echo e($transaction->batch ? $transaction->batch->itemBatchMaster->batch_no : ''); ?>

                       </td>
                       <?php endif; ?>
                       <?php if(app('company')['enable_mfg_date']): ?>
                       <td>
                           <?php echo e($transaction->batch ? $formatDate->toUserDateFormat($transaction->batch->itemBatchMaster->mfg_date) : ''); ?>

                       </td>
                       <?php endif; ?>
                       <?php if(app('company')['enable_exp_date']): ?>
                       <td>
                           <?php echo e($transaction->batch ? $formatDate->toUserDateFormat($transaction->batch->itemBatchMaster->exp_date) : ''); ?>

                       </td>
                       <?php endif; ?>
                       <?php if(app('company')['enable_model']): ?>
                       <td>
                           <?php echo e($transaction->batch ? $transaction->batch->itemBatchMaster->model_no : ''); ?>

                       </td>
                       <?php endif; ?>

                       <?php if(app('company')['enable_color']): ?>
                       <td>
                           <?php echo e($transaction->batch ? $transaction->batch->itemBatchMaster->color :''); ?>

                       </td>
                       <?php endif; ?>
                       <?php if(app('company')['enable_size']): ?>
                       <td>
                           <?php echo e($transaction->batch ? $transaction->batch->itemBatchMaster->size : ''); ?>

                       </td>
                       <?php endif; ?>
                   <?php endif; ?>
                   <?php if(app('company')['show_mrp']): ?>
                   <td>
                       <?php echo e($formatNumber->formatWithPrecision($transaction->batch ? $transaction->batch->itemBatchMaster->mrp : $transaction->mrp)); ?>

                   </td>
                   <?php endif; ?>
                   <td class="text-end">
                        <?php echo e($formatNumber->formatQuantity($transaction->quantity)); ?><br>
                        <small><?php echo e($transaction->unit->name); ?></small>
                    </td>
                    <td class=" text-end">
                        <?php echo e($formatNumber->formatWithPrecision($transaction->unit_price)); ?>

                    </td>
                    <?php if(app('company')['show_discount']): ?>
                    <td class=" text-end">
                        <?php echo e($formatNumber->formatWithPrecision($transaction->discount_amount)); ?><br>
                        <small>
                            (<?php echo e($formatNumber->formatWithPrecision($transaction->discount)); ?>

                                <?php echo e(($transaction->discount_type == 'fixed') ? '$' : '%'); ?>)
                        </small>
                    </td>
                    <?php endif; ?>
                    <?php if(app('company')['tax_type'] != 'no-tax'): ?>
                    <td class="text-end">
                        <?php echo e($formatNumber->formatWithPrecision($transaction->tax_amount)); ?><br>
                        <small>(<?php echo e($transaction->tax->rate); ?>%)</small>
                    </td>
                    <?php endif; ?>
                    <td class="text-end">
                        <?php echo e($formatNumber->formatWithPrecision($transaction->total)); ?>

                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                <tr class="fw-bold">
                    <td class="text-end" colspan="<?php echo e(2 + $totalBatchTrackingRowCount + app('company')['show_hsn'] + app('company')['show_mrp']); ?>">
                            <?php echo e(__('app.total')); ?>

                    </td>
                    <td class="text-end">
                            <?php echo e($formatNumber->formatWithPrecision($order->itemTransaction->sum('quantity'))); ?>

                    </td>
                    <td></td>
                    <?php if(app('company')['show_discount']): ?>
                    <td class="text-end">
                            <?php echo e($formatNumber->formatWithPrecision($order->itemTransaction->sum('discount_amount'))); ?>

                    </td>
                    <?php endif; ?>
                    <?php if(app('company')['tax_type'] != 'no-tax'): ?>
                    <td class="text-end">
                            <?php echo e($formatNumber->formatWithPrecision($order->itemTransaction->sum('tax_amount'))); ?>

                    </td>
                    <?php endif; ?>
                    <td class="text-end">
                            <?php echo e($formatNumber->formatWithPrecision($order->itemTransaction->sum('total'))); ?>

                    </td>
                </tr>
            </tbody>
            <tfoot>
                <?php
                $subtotal = $order->itemTransaction->sum(function ($transaction) {
                            /*if($transaction->tax_type == 'inclusive'){
                                $unitPrice = calculatePrice($transaction->unit_price, $transaction->tax->rate, needInclusive: true);
                            }else{
                                $unitPrice = calculatePrice($transaction->unit_price, $transaction->tax->rate, needInclusive: false);
                            }*/
                            $unitPrice = $transaction->unit_price;
                            return $unitPrice * $transaction->quantity;
                        });
                $discount = $order->itemTransaction->sum(function ($transaction) {
                            return $transaction->discount_amount;
                        });

                $taxAmount = $order->itemTransaction->sum(function ($transaction) {
                            return $transaction->tax_amount;
                        });

                ?>

                <?php
                    $noteColumns = 4 + $totalBatchTrackingRowCount + app('company')['show_hsn'] + app('company')['show_mrp'] - ((app('company')['tax_type'] =='no-tax') ? 1 : 0) - (app('company')['show_discount'] ? 0 : 1);
                    $noteRosSpan = 4 - ((app('company')['tax_type'] =='no-tax') ? 1 : 0);

                    $amountInWordsRowSpan = 3 + app('company')['show_mrp'] + app('company')['show_party_due_payment'] + app('company')['is_enable_secondary_currency'];
                ?>
                <tr>
                    <td colspan="<?php echo e($noteColumns); ?>" rowspan="<?php echo e($noteRosSpan); ?>" class="tfoot-first-td">
                        <span class="invoice-note">Note:<br></span><?php echo e($order->note); ?>

                    </td>
                    <td colspan="2" class="text-end fw-bold"><?php echo e(__('app.subtotal')); ?></td>
                    <td colspan="1" class="text-end"><?php echo e($formatNumber->formatWithPrecision($subtotal)); ?></td>
                </tr>
                <tr>
                    <td colspan="2" class="text-end fw-bold"><?php echo e(__('app.discount')); ?></td>
                    <td colspan="1" class="text-end"><?php echo e($formatNumber->formatWithPrecision($discount)); ?></td>
                </tr>
                <?php if(app('company')['tax_type'] != 'no-tax'): ?>
                <tr>
                    <td colspan="2" class="text-end fw-bold"><?php echo e(__('tax.tax')); ?></td>
                    <td colspan="1" class="text-end"><?php echo e($formatNumber->formatWithPrecision($taxAmount)); ?></td>
                </tr>
                <?php endif; ?>
                <tr>
                    <td colspan="2" class="text-end fw-bold"><?php echo e(__('app.round_off')); ?></td>
                    <td colspan="1" class="text-end"><?php echo e($formatNumber->formatWithPrecision($order->round_off)); ?></td>
                </tr>
                <tr>
                    <td colspan="<?php echo e($noteColumns); ?>" rowspan="<?php echo e($amountInWordsRowSpan); ?>" class="tfoot-first-td">
                        <b><?php echo e(__('app.amount_in_words')); ?>:<br></b>
                        <?php echo e(ucwords($formatNumber->spell($order->grand_total))); ?>

                    </td>
                    <td colspan="2" class="text-end fw-bold"><?php echo e(__('app.grand_total')); ?></td>
                    <td colspan="1" class="text-end"><?php echo e($formatNumber->formatWithPrecision($order->grand_total)); ?></td>
                </tr>
                <?php if(app('company')['is_enable_secondary_currency']): ?>
                    <tr>
                        <td colspan="2" class="text-end fw-bold"><?php echo e(__('currency.converted_to').'-'.$order->currency->code); ?></td>
                        <td colspan="1" class="text-end"><?php echo e($formatNumber->formatWithPrecision($order->grand_total * $order->exchange_rate)); ?></td>
                    </tr>
                <?php endif; ?>
                <tr>
                    <td colspan="2" class="text-end fw-bold"><?php echo e(__('payment.paid_amount')); ?></td>
                    <td colspan="1" class="text-end"><?php echo e($formatNumber->formatWithPrecision($order->paid_amount)); ?></td>
                </tr>
                <tr>
                    <td colspan="2" class="text-end fw-bold"><?php echo e(__('payment.balance')); ?></td>
                    <td colspan="1" class="text-end"><?php echo e($formatNumber->formatWithPrecision($order->grand_total - $order->paid_amount)); ?></td>
                </tr>
                <?php if(app('company')['show_mrp']): ?>
                <tr>
                    <?php
                        $savedAmount = $order->itemTransaction->sum(function ($transaction) {
                                    if($transaction->mrp > 0){
                                        return ($transaction->mrp * $transaction->quantity) - $transaction->total;
                                    }else{
                                        return 0;
                                    }
                            });

                    ?>
                    <td colspan="2" class="text-end fw-bold"><?php echo e(__('app.you_saved')); ?></td>
                    <td colspan="1" class="text-end"><?php echo e($formatNumber->formatWithPrecision($savedAmount)); ?></td>
                </tr>
                <?php endif; ?>
                <?php if(app('company')['show_party_due_payment']): ?>
                <tr>
                    <?php
                        $partyTotalDue = $order->party->getPartyTotalDueBalance();
                        $partyTotalDueBalance = $partyTotalDue['status']=='you_pay'
                                                        ?
                                                        (-1 * $partyTotalDue['balance'])
                                                        :
                                                        $partyTotalDue['balance'];
                    ?>
                    <td colspan="2" class="text-end fw-bold"><?php echo e(__('app.total_due_balance')); ?></td>
                    <td colspan="1" class="text-end"><?php echo e($formatNumber->formatWithPrecision($partyTotalDueBalance)); ?></td>
                </tr>
                <?php endif; ?>
            </tfoot>
        </table>


        <?php if(app('company')['show_tax_summary'] && app('company')['tax_type'] != 'no-tax'): ?>
        <table class="table table-bordered custom-table tax-breakdown table-compact">
            <thead>
                <?php if(app('company')['tax_type'] == 'tax'): ?>
                    <tr>
                        <th><?php echo e(__('tax.tax')); ?></th>
                        <th><?php echo e(__('tax.taxable_amount')); ?></th>
                        <th><?php echo e(__('tax.rate')); ?></th>
                        <th><?php echo e(__('tax.tax_amount')); ?></th>
                    </tr>
                 <?php else: ?>
                    
                     <tr>
                        <th rowspan="2"><?php echo e(__('item.hsn')); ?></th>
                        <th rowspan="2"><?php echo e(__('tax.taxable_amount')); ?></th>
                        <th colspan="2" class="text-center"><?php echo e(__('tax.cgst')); ?></th>
                        <th colspan="2" class="text-center"><?php echo e(__('tax.sgst')); ?></th>
                        <th colspan="2" class="text-center"><?php echo e(__('tax.igst')); ?></th>
                        <th rowspan="2"><?php echo e(__('tax.tax_amount')); ?></th>
                    </tr>
                    <tr>
                        <th><?php echo e(__('tax.rate')); ?>%</th>
                        <th><?php echo e(__('app.amount')); ?></th>
                        <th><?php echo e(__('tax.rate')); ?>%</th>
                        <th><?php echo e(__('app.amount')); ?></th>
                        <th><?php echo e(__('tax.rate')); ?>%</th>
                        <th><?php echo e(__('app.amount')); ?></th>
                    </tr>
                <?php endif; ?>
            </thead>
            <tbody>
                <?php

                if(app('company')['tax_type'] == 'tax'){
                    $taxSummary = $order->itemTransaction
                        ->groupBy('tax_id')
                        ->map(function ($group) {
                            $firstItem = $group->first();
                            $totalTaxableAmount = $group->sum(function ($item) use ($firstItem) {
                                $totalOfEachItem = ($item->unit_price-$item->discount_amount) * $item->quantity;
                                return $totalOfEachItem;
                                /*if ($item->tax_type == 'inclusive') {
                                    return calculatePrice($totalOfEachItem, $firstItem->tax->rate, needInclusive: true);
                                } else {
                                    return calculatePrice($totalOfEachItem, $firstItem->tax->rate, needInclusive: false);
                                }*/
                            });
                            return [
                                'tax_id' => $firstItem->tax_id,
                                'tax_name' => $firstItem->tax->name,
                                'tax_rate' => $firstItem->tax->rate,
                                'total_taxable_amount' => $totalTaxableAmount,
                                'total_tax' => $group->sum('tax_amount')
                            ];
                        })
                        ->values();
                }
                else{
                    //GST
                    $taxSummary = $order->itemTransaction
                    ->groupBy('item.hsn') // First group by HSN
                    ->map(function ($hsnGroup) {
                        return $hsnGroup->groupBy('tax_id') // Then group by tax_id within each HSN group
                            ->map(function ($group) {
                                $firstItem = $group->first();
                                $totalTaxableAmount = $group->sum(function ($item) {
                                    $totalOfEachItem = ($item->unit_price - $item->discount_amount) * $item->quantity;
                                    return $totalOfEachItem;
                                    /*
                                    if ($item->tax_type == 'inclusive') {
                                        return calculatePrice($totalOfEachItem, $item->tax->rate, needInclusive: true);
                                    } else {
                                        return calculatePrice($totalOfEachItem, $item->tax->rate, needInclusive: false);
                                    }*/
                                });
                                return [
                                    'hsn' => $firstItem->item->hsn,
                                    'tax_id' => $firstItem->tax_id,
                                    'tax_name' => $firstItem->tax->name,
                                    'tax_rate' => $firstItem->tax->rate,
                                    'total_taxable_amount' => $totalTaxableAmount,
                                    'total_tax' => $group->sum('tax_amount')
                                ];
                            });
                    })
                    ->flatMap(function ($hsnGroup) {
                        return $hsnGroup;
                    })
                    ->values();
                }

                ?>
                <?php $__currentLoopData = $taxSummary; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $summary): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if(app('company')['tax_type'] == 'tax'): ?>
                    <tr>
                        <td><?php echo e($summary['tax_name']); ?></td>
                        <td class="text-end"><?php echo e($formatNumber->formatWithPrecision($summary['total_taxable_amount'])); ?></td>
                        <td class="text-center"><?php echo e($summary['tax_rate']); ?>%</td>
                        <td class="text-end"><?php echo e($formatNumber->formatWithPrecision($summary['total_tax'])); ?></td>
                    </tr>
                    <?php else: ?>
                    <tr>
                        <td><?php echo e($summary['hsn']); ?></td>
                        <td class="text-end"><?php echo e($formatNumber->formatWithPrecision($summary['total_taxable_amount'])); ?></td>

                        <?php
                            $cs_gst = $i_gst = '';
                            $cs_gst_amt = $i_gst_amt = '';
                            if(empty($order->state_id) || app('company')['state_id'] == $order->state_id){
                                $cs_gst = ($summary['tax_rate']/2).'%';
                                $cs_gst_amt = $formatNumber->formatWithPrecision($summary['total_tax']/2);
                            }else{
                                $i_gst = ($summary['tax_rate']).'%';
                                $i_gst_amt = $formatNumber->formatWithPrecision($summary['total_tax']);
                            }
                        ?>
                        <!-- CGST & SGT -->
                        <td class="text-center"><?php echo e($cs_gst); ?></td>
                        <td class="text-end"><?php echo e($cs_gst_amt); ?></td>
                        <td class="text-center"><?php echo e($cs_gst); ?></td>
                        <td class="text-end"><?php echo e($cs_gst_amt); ?></td>
                        <!-- IGST -->
                        <td class="text-center"><?php echo e($i_gst); ?></td>
                        <td class="text-end"><?php echo e($i_gst_amt); ?></td>
                        <td class="text-end"><?php echo e($formatNumber->formatWithPrecision($summary['total_tax'])); ?></td>
                    </tr>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
        <?php endif; ?>

        <?php echo $__env->make('print.common.terms-conditions', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <?php echo $__env->make('print.common.bank-signature', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


    </div>
    </div>
</body>
</html>
<?php /**PATH /home/eltaqwa/public_html/delta-source-code/resources/views/print/purchase-order.blade.php ENDPATH**/ ?>