<!DOCTYPE html>
<html lang="ar" dir="<?php echo e($appDirection); ?>">
<head>
    <meta charset="UTF-8">
    <title><?php echo e($printData['name']); ?></title>
    <?php echo $__env->make('print.common.css', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</head>
<body onload="window.print();">
    <div class="invoice-container">
        <span class="invoice-name"><?php echo e($printData['name']); ?></span>
        <div class="invoice">
            <table class="header">
                <tr>
                    <?php echo $__env->make('print.common.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                    <td class="bill-info">
                        <span class="bill-number">#: <?php echo e($expense->expense_code); ?></span><br>
                        <span class="cu-fs-16"><?php echo e(__('app.date')); ?>: <?php echo e($expense->formatted_expense_date); ?></span><br>
                        <span class="cu-fs-16"><?php echo e(__('app.time')); ?>: <?php echo e($expense->format_created_time); ?></span><br>
                    </td>
                </tr>
            </table>

            <table class="addresses">
                <tr>
                    <td class="address" colspane="2">
                        <span class="fw-bold cu-fs-18"><?php echo e(__('expense.expense_category')); ?></span> :
                        <span><?php echo e($expense->category->name); ?></span>
                        <?php if($expense->subcategory): ?>
                        <br>
                        <span class="fw-bold cu-fs-18"><?php echo e(__('expense.subcategory.subcategory')); ?></span> :
                        <span><?php echo e($expense->subcategory->name); ?></span>
                        <?php endif; ?>

                    </td>
                </tr>
            </table>

        <table class="table-bordered custom-table table-compact" id="item-table">
            <thead>
                <tr>
                    <th>#</th>
                    <th><?php echo e(__('item.item')); ?></th>
                    <th><?php echo e(__('app.qty')); ?></th>
                    <th><?php echo e(__('app.price_per_unit')); ?></th>
                    <th><?php echo e(__('app.total')); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php
                    $i=1;
                ?>
                <?php $__currentLoopData = $expenseItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $items): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                   <td class="no"><?php echo e($i++); ?></td>
                   <td>
                    <?php echo e($items->itemDetails->name); ?>

                    <br>
                    <small><?php echo e($items->note); ?></small>
                   </td>
                   <td class="">
                        <?php echo e($formatNumber->formatQuantity($items->quantity)); ?>

                    </td>
                    <td class="text-end">
                        <?php echo e($formatNumber->formatWithPrecision($items->unit_price)); ?>

                    </td>
                    <td class="text-end">
                        <?php echo e($formatNumber->formatWithPrecision($items->total)); ?>

                    </td>

                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            </tbody>
            <tfoot class="fw-bold">
                <tr>
                    <td colspan="4" class="text-end"><?php echo e(__('app.round_off')); ?></td>
                    <td class="text-end"><?php echo e($formatNumber->formatWithPrecision($expense->round_off)); ?></td>
                </tr>
                <tr>
                    <td colspan="4" class="text-end"><?php echo e(__('app.grand_total')); ?></td>
                    <td class="text-end"><?php echo e($formatNumber->formatWithPrecision($expense->grand_total)); ?></td>
                </tr>
                <tr>
                    <td colspan="4" class="text-end"><?php echo e(__('payment.paid_amount')); ?></td>
                    <td class="text-end"><?php echo e($formatNumber->formatWithPrecision($expense->paid_amount)); ?></td>
                </tr>
            </tfoot>

        </table>



        <?php echo $__env->make('print.common.bank-signature', ['hideBankDetails'=> true], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


    </div>
    </div>
</body>
</html>
<?php /**PATH /home/eltaqwa/public_html/delta-source-code/resources/views/print/expense/print.blade.php ENDPATH**/ ?>